#|___________________________________________________________________ 
 | 
 | ViSta - The Visual Statistics System
 | Copyright (c) 1991-2000 by Forrest W. Young
 | For further information contact the author 
 | forrest@unc.edu or http://forrest.psych.unc.edu
 |
 | This file contains old code (1991-1998) for creating paths.
 | Probably this code no longer needs to be loaded. 
 | It should be replaced entirely by the code in
 | the paths.lsp file in maketime folder.
 |___________________________________________________________________ 
 |#

(defun find-prefs-path (look-here &key silent)
"Looks in LOOK-HERE-DIR, for a PREFS directory containing a PREFLOAD.LSP file. Returns pathname of PREFS directory or nil. Will not print when silent is t."
  (let* ((local-prefs-path)
         (loaded))

    #-macintosh
    (if (equal #\\ (select (reverse look-here) 0))
        (setf local-prefs-path look-here)
        (setf local-prefs-path (strcat look-here *separator*)))
    #+macintosh
    (setf local-prefs-path look-here)
    
    (setf local-prefs-path (strcat local-prefs-path "prefs" *separator*))
    (when *v* (format t "; check-prefs-path ~a~%"local-prefs-path))
    (when (and (not silent) *v*) 
          (format t "; looking for file: ~a~%" 
                  (strcat local-prefs-path "prefload.lsp")))
    (setf local-prefs-path (load-prefload-file local-prefs-path silent))
    local-prefs-path))

(defun load-prefload-file (local-prefs-path silent)
  (let ((look-for-pref-file (strcat local-prefs-path "prefload.lsp"))
        (OPENED))
    (when (and (not silent) *v*) 
          (format t "; Looking for prefload file: ~a~%" look-for-pref-file))
    (setf OPENED (OPEN look-for-pref-file :if-does-not-exist nil))
    (when (not OPENED) (setf local-prefs-path nil))
    (when (and (not silent) *v*) 
          (if OPENED
              (format t "; FOUND AND OPENED PREFLOAD.LSP~%")
              (format t "; DID NOT FIND PREFLOAD.LSP~%")))
    local-prefs-path))

(defun find-user-path (look-here-dir &key silent (user-sub-directory t))
"Looks for USER subdirectory in LOOK-HERE-DIR. If USER-SUB-DIRECTORY is NIL (T by default) looks for LOOK-HERE-DIR.  Returns pathname or nil. Will not print when silent is t."
  (let* ((worker (get-working-directory))
         (local-user-dir look-here-dir)
         (local-user-path)
         (found-it))
    #-macintosh
    (if (equal *separator* (select (reverse local-user-dir) (iseq 1)))
       ;(equal *separator* (subseq (reverse local-user-dir) 0 1))?
        (setf local-user-path local-user-dir)
        (setf local-user-path (strcat local-user-dir *separator*))
        )
    #+macintosh (setf local-user-path local-user-dir)
    (when *v* (format t "; check-user-path ~a~%"local-user-path))
    (cond
      ((> (length local-user-path) 5)
       (when (not (equal (strcat *separator* "resu" *separator*)
                         (select (reverse local-user-path)  (iseq 6))))
             (setf local-user-path 
                   (strcat local-user-path "user" *separator*)))
       (when *v* (format t "; check-user-path ~a~%"local-user-path))
       (when (not (set-working-directory local-user-path))
             (setf local-user-path nil)))
      (t (setf local-user-path nil)))
    (when *v*
          (if local-user-path
              (format t "; FOUND USER PATH~%")
              (format t "; DID NOT FIND USER PATH~%")))
    (set-working-directory worker)
    local-user-path))


(defun rename-ini ()
  (let ((win9598 (probe-file "c:\\windows\\wxls32.ini"))
        (winnt   (probe-file "c:\\winnt\\wxls32.ini"))
        )
    (cond
      (win9598
       (rename-file "c:\\windows\\wxls32.ini" "c:\\windows\\wxls32bk.ini"))
      (winnt
       (rename-file "c:\\winnt\\wxls32.ini" "c:\\winnt\\wxls32bk.ini"))
      (nil))))

      

(defun find-ini-paths (&key silent)
"Looks for WXLS32.INI file and checks it for valid lib and user directories. Returns a list of four values - ini-lib-path, ini-user-path, ini-pref-path and ini-exists?. First three are paths when found, Nils when not found. Last is T/Nil for finding ini file. Searche Path: 1st: local .exe directory; 2nd: current-directory; 3rd: Win95 or WinNT dir (32-bit first, 16-bit second, if exists); 4th: Windows dir; 5) directories given in PATH variable; then error"
  (unless *ini-file* (define-ini-file))
  (let ((xlibdir (msw-get-profile-string "Xlisp" "Libdir"  *ini-file*))
        (vlibdir (msw-get-profile-string "ViSta" "Libdir"  *ini-file*))
        (usrdir  (msw-get-profile-string "ViSta" "Userdir" *ini-file*))
        (prfdir  (msw-get-profile-string "ViSta" "Prefdir" *ini-file*))
        (wrkdir  (get-working-directory))
        (libdir)
        (result)
        (ini-exists?)
        (ini-lib-path)(showmainwindow)
        (ini-user-path)
        (ini-pref-path)
        (xlibpath)
        )
;; Check to see if there is a WXLS32.INI file.
    (cond
      (*ini-at-home* 
       (setf *ini-file* (strcat *default-path* "wxls32.ini")) 
       (when (and (not silent) *v*)
             (format t "~%; INI file confined to: ~a~%" *ini-file*))
       (setf ini-exists? (probe-file *ini-file*))
       )
      (t
       (when (and (not silent) *v*)
             (format t "~%; INI file not confined to home directory."))
       (when (and (not silent) *v*) (format t "~%; LOOKING FOR WXLS32.INI FILE.~%"))
       (when (and xlibdir (not vlibdir))
             (format t "; Found non-ViSta WXLS32.INI file. Adding ViSta info.~%"))
       (setf ini-exists? (if vlibdir t nil))
       (when xlibdir (setf xlibpath (strcat xlibdir "\\")))
       ))
    (cond 
      (ini-exists?
       (when (and (not silent) *v*)
             (format t "; Found ViSta WXLS32.INI file. Validating its directories.~%"))
;; If ini exists, look for its ViStalibrary, ViStausr & ViStaprefs directories
       (when vlibdir   
             (setf result (when vlibdir (set-working-directory vlibdir)))
             (when (and *v* (not result)) 
                   (format t "; Invalid WXLS32.INI ViStaLibDir specified: ~a~%"
                           vlibdir))
             (when result 
                   (setf ini-lib-path (strcat (get-working-directory) "\\"))
                   (when (and (not silent) *v*) 
                         (format t "; The WXLS32.INI ViStaLibPath is: ~a~%" ini-lib-path))
                   ))
       (when usrdir
             (setf result (when usrdir (set-working-directory usrdir)))
             (when (and (and (not silent) *v*) (not result)) 
                   (format t "; Invalid WXLS32.INI ViStaUsrDir specified: ~a~%" usrdir))
             (when result 
                   (setf ini-user-path (strcat usrdir *separator*)) 
                   (when (and (not silent) *v*) (format t "; The WXLS32.INI ViStaUsrPath is: ~a~%" ini-user-path))
                   ))
       (when prfdir
           ; (setf result (when prfdir (set-working-directory prfdir)))
             (setf result (when prfdir (load-prefload-file (strcat prfdir "\\") silent)))
             (when (and (and (not silent) *v*) (not result)) 
                   (format t "; Invalid WXLS32.INI ViStaPrfDir specified: ~a~%" prfdir))
             (when result 
                   (setf ini-pref-path (strcat prfdir *separator*)) 
                   (when (and (not silent) *v*) (format t "; The WXLS32.INI ViStaPrfPath is: ~a~%" ini-pref-path))
                   ))
       (cond
         ((or (not ini-user-path ) (not ini-lib-path ) (not ini-pref-path))
          (when (and (not silent) *v*)(format t "; Invalid WXLS32.INI ViSta directory information~%"))
          (when (and (not silent) *v*)(format t ";            lib-path ~a~%;            user-path ~a~%;            pref-path ~a~2%"
                  ini-lib-path ini-user-path ini-pref-path)))
         (t (when (and (not silent) *v*)(format t "; Valid WXLS32.INI ViSta directory information.")))))
      (t
       (when (and (not silent) *v*)(format t "; Valid ViSta WXLS32.INI file not found."))))
    (set-working-directory wrkdir)
    (when *ini-at-home* (setf xlibpath ini-lib-path))
    (list xlibpath ini-lib-path ini-user-path ini-pref-path ini-exists? )))
    
(defun search-default-prefs-paths (*path*)
  (if *v* (format t "; searching default paths~%"))
  (mapcar #'(lambda (path) 
              (when (and path (not *path*))
                    (setf *path* (find-prefs-path path))
                    (if *path* 
                        (when *v* (format t "; found: ~a~%" *path*)))))
          (remove-duplicates (combine *default-path* *load-pathname-defaults*)))
  *path*)

(defun search-default-user-paths (*path*)
  (if *v* (format t "; searching default paths~%"))
  (mapcar #'(lambda (path) 
              (when (and path (not *path*))
                    (setf *path* (find-user-path path))
                    (if *path* 
                        (when *v* (format t "; found: ~a~%" *path*)))))
          (remove-duplicates (combine *default-path* *load-pathname-defaults*)))
  *path*)

  (defun get-user-path ()
    (let* ((text "No ViSta User Directory")
           (title-item (send text-item-proto :new 
             (FORMAT nil "WARNING!!!~%THERE IS NO USER DIRECTORY!!!")))
           (text1-item (send text-item-proto :new
             (format nil "In Networked NT Environments You May Be~%Unable to Save Your Results There Must Be One.")))
           (user-dir (send edit-text-item-proto :new
                           "                                     "))
           (ok (send modal-button-proto :new "Create Directory"
                     :action #'(lambda () 
                                 (send user-dir :text))))
           (cancel (send modal-button-proto :new "No Directory"))
           (dialog (send modal-dialog-proto :new 
                         (list title-item text1-item user-dir
                               (list ok cancel))
                         :title text)))
      (send dialog :modal-dialog)
      ))


(defun no-user-dir ()
  (let ((dir-now (get-working-directory))
        (yesno (two-button-dialog (format nil "Your USER directory does not exist.~%You cannot save results. Continue anyway?") :first-button "Continue" :second-button "Exit ViSta"))
        )
    (if yesno (load-vista) (exit))))

(defun new-ini-dialog ()
  (cond
    ((not *standard-installation*)
     (let* ((paths (send text-item-proto :new (format nil "~%   System path:~a~%ViSta.exe path: ~a~%    prefs path: ~a~%    users path: ~a~%   WXLS32.exe path: ~a"
                       *system-path* *lib-path*  *prefs-path* *user-path* *xlib-path* )))
            (question (send text-item-proto :new 
                            "PUT THESE PATHS IN WXLS32.INI?"))
            (prefile (strcat *prefs-path* "prefload.lsp"))
            (ok (send modal-button-proto :new "Yes - Use These Paths"
                      :action #'(lambda () 
                                  (setf *no-dir-dialog* t)
                                  (setf *change-fonts* t)
                                  (setf *change-directories* t)
                                  t)))
            (ok2 (send modal-button-proto :new "No - Let me Change Paths"
                       :action #'(lambda () 
                                   (setf *no-dir-dialog* nil)
                                   (setf *change-fonts* t)
                                  (setf *change-directories* t)
                                   t)))
            (no (send modal-button-proto :new "No - Do Not Touch WXLS32.INI"
                      :action #'(lambda ()
                                   (setf *no-dir-dialog* t)
                                   (setf *change-fonts* nil)
                                  (setf *change-directories* nil)                                   nil )))
            (dialog (send modal-dialog-proto :new 
                          (list question paths ok ok2 no)
                          :default-button ok)))
       (send dialog :modal-dialog)))
    (t
     (setf *no-dir-dialog* t)
     (setf *change-fonts* nil)
     (setf *change-directories* nil)
     nil)))


